var url = document.location.href;
var xmlhttp = new XMLHttpRequest;

function GetToken(str, token)
{
	var idx = str.indexOf(token + '=');
	if (idx <= 0) return null;
	var argstr = str.substring(idx + token.length + 1);
	idx = argstr.indexOf('&');
	return idx >=0 ? argstr.substring(0, idx) : argstr;
}

function SetPref(param, val)
{
	xmlhttp.open("GET", "/prefs/set?" + param + "=" + val, false);
	xmlhttp.send(null);
}

function GetPref(param)
{
	xmlhttp.open("GET", "/prefs/get?path=" + param, false);
	xmlhttp.send(null);
	return xmlhttp.responseText;
}

function GetPrefInt(param)
{
	xmlhttp.open("GET", "/prefs/get?type=int&path=" + param, false);
	xmlhttp.send(null);
	return parseInt(xmlhttp.responseText);
}

function RevertPrefValue(param)
{
	xmlhttp.open("GET", "/prefs/revert?path=" + param, false);
	xmlhttp.send(null);
	return xmlhttp.responseText;
}

function loadXML(xmlFile)
{
	var $xml = new XMLHttpRequest;
	$xml.open('GET', xmlFile, false);
	$xml.overrideMimeType('text/xml');
	$xml.send(null);
	var xml = $xml.responseXML;
	if (!xml) {
		alert("Unable to load "+xmlFile);
		return null;
	}
	return xml;
}

function transformXML(xmlDoc, xslDoc, element)
{
	var XSLT = new XSLTProcessor;
	XSLT.importStylesheet(xslDoc);
	var e = document.getElementById(element);
	if (e) {
		while (e.firstChild) e.removeChild(e.firstChild);
		e.appendChild(XSLT.transformToFragment(xmlDoc, document));
	}
}

function trim(stringToTrim) {
	return stringToTrim.replace(/^\s+|\s+$/g,"");
}
function ltrim(stringToTrim) {
	return stringToTrim.replace(/^\s+/,"");
}
function rtrim(stringToTrim) {
	return stringToTrim.replace(/\s+$/,"");
}

var xmlCodecInfo;

function onChangeAudioCodec(me)
{
	SetPref("videoenc.wm.audioCodec", me.selectedItem.label);
	RefreshFormats(me.selectedIndex, document.getElementById('modeList').selectedIndex);
}

function onChangeAudioMode(me)
{
	SetPref("videoenc.wm.audioMode", me.selectedItem.label);
	RefreshFormats(document.getElementById('codecList').selectedIndex, me.selectedIndex);
	SetPref('videoenc.wm.audioFormat', document.getElementById("formatList").selectedItem.getAttribute("label"));
}

function onChangeVideoMode(me)
{
	SetPref('overall.video.mode', me.selectedIndex)
	document.getElementById("bitrateDeck").selectedIndex = me.selectedIndex == 1 ? 1 : 0;
}

function RefreshFormats(codecIndex, modeIndex)
{
	var r = xmlCodecInfo.getElementsByTagName("category");
	var codecs = r[0].getElementsByTagName("codec");	// audio category
	var modes = codecs[codecIndex].getElementsByTagName("mode");
	var formats = modes[modeIndex].getElementsByTagName("format");

        var e = document.getElementById("formatList");
	var name;
	var idx = 0;
	v = GetPref("videoenc.wm.audioFormat");
	e.removeAllItems();
        for (i = 0; i < formats.length; i++) {
		name = trim(formats[i].childNodes[1].firstChild.nodeValue);
                e.appendItem(name, "", "");
		if (name == v) idx = i;
        }
	e.selectedIndex = idx;
}

function Refresh()
{
	var r = xmlCodecInfo.getElementsByTagName("category");

	// update audio codec list
	var codecs = r[0].getElementsByTagName("codec");	// audio codecs
	var v = GetPref("videoenc.wm.audioCodec");
        e = document.getElementById("codecList");
	var audioCodecIndex = 0;
	var name;
	e.removeAllItems();
        for (i = 0; i < codecs.length; i++) {
		name = codecs[i].getAttribute("name");
                e.appendItem(name, "", "");
		if (name == v) audioCodecIndex = i;
        }
	e.selectedIndex = audioCodecIndex;

	// update mode list
	var modes = codecs[audioCodecIndex].getElementsByTagName("mode");
	v = GetPref("videoenc.wm.audioMode");
        e = document.getElementById("modeList");
	var audioModeIndex = 0;
	e.removeAllItems();
        for (i = 0; i < modes.length; i++) {
		name = modes[i].getAttribute("name");
                e.appendItem(name, "", "");
		if (v == name) audioModeIndex = i;
        }
	e.selectedIndex = audioModeIndex;

	// update video codec list
	var codecs = r[1].getElementsByTagName("codec");	// video codecs
        var e = document.getElementById("videoCodecList");
	var videoCodecIndex = 0;
	v = GetPref("videoenc.wm.videoCodec");
	e.removeAllItems();
        for (i = 0; i < codecs.length; i++) {
		var name = trim(codecs[i].getAttribute("name"));
                e.appendItem(name, "", "");
		if (name == v) videoCodecIndex = i;
        }
	e.selectedIndex = videoCodecIndex;
	
	RefreshFormats(audioCodecIndex, audioModeIndex);
	
	var vmode = GetPrefInt("overall.video.mode");
	document.getElementById("videoMode").selectedIndex = vmode;
	document.getElementById("bitrateDeck").selectedIndex = vmode == 1 ? 1 : 0;
	
	// video bitrate
	e = document.getElementById("vb");
	v = GetPref("overall.video.bitrate");
	e.value = v;
	e.nextSibling.setAttribute("curpos", v);
	
	// video quality
	e = document.getElementById("vq");
	v = GetPref("overall.video.quality");
	e.value = v;
	e.nextSibling.setAttribute("curpos", v);
}

function Init()
{
	var e = document.getElementById("wmcfg");
	window.innerWidth = e.width;
	window.innerHeight = e.height;
	
	xmlCodecInfo = loadXML("/mc/wmcodecs.xml");
	
	Refresh();
}
